;*************************************************************************
; Program  : SCOPE.ASM (use EVM CODEC as a time domain ossiloscope or
;            frequency domain spectrum analyser.)
;            Use spy.c with this program.
; Author   : Danie Brynard zs6awk
; Email    : danie.brynard@pixie.co.za
; File     : scope.asm
; Update   : Sat 12/8/95
; Target   : DSP56002EVM rev2.2
; Compiler : ASM56000.exe  Ver 5.3.2
; Notes    : Based on examples from ALEFNUL (Jarkko Vuori, OH2LNS)
;            Use bios.asm amd leonid.asm as modified for EVM by KC7WW
; ToDo     : Toggle PTT led when 512 words are being send...
;*************************************************************************
	nolist
        include 'leonid'      ; basic i/o routines written by ALEFNUL
	list

buflen  equ     16            ; input buffer length
; flags
spyflg  equ     3                                   ; spy on/off

        org     p:user_code   ; my program code..

        move    #buffer+2,r7  ; r7 & m7 point to desired sample buffer
        move    #buflen*4-1,m7

        move    #buffer,r2
        move    #4-1,n2
        move    #buflen*4-1,m2
        ; MIC instead off LINEI ???
        ; this works on the EVM..
	ctrlcd	1,r2,buflen,MIC,0.0,0.0,LINEO|HEADP,0.0,0.0
        opencd  9.6,NOHPF ;8-48kHz sample rate & NOHPF or HPF

; Send sign-on message to PC via SCI port:
        move    #0,a1      ; normal mode NOT KISS
        opensc
        move    #>'E',x0
        putc
        move    #>'V',x0
        putc
        move    #>'M',x0
        putc
        move    #>'>',x0

; -------------------------------------------------------------------------
; wait for one complete block
loop    waitblk r2,buflen,1   ;reg,buflen,blklen
                              ; x:(reg) point to input data in x-memory
                              ; buflen=16  & blklen=1

        move                r2,r0     ;r0=r2= left channel
        move                (r2)+     ;inc ptr to left channel output
        move                x:(r0),a  ;store x-input sample in a-reg for spy
        ; send one sample to SPY receiver on PC
        ; move  #>$41,a  ; test byte, the char 'A'
        jsr    <spy
        move                a,y:(r2)+ ; left channel out + post increment
        move                a,y:(r2)+ ; right channel out + post increment
        move                    (r2)+ ; inc to next x input sample

        jmp     <loop        ; go get another sample..

; -------------------------------------------------------------------------
; *** DEBUG ***
; special spy
spy     jset    #spyflg,x:<flag,_spyon  ; see if spy already active

        lookc   0                       ; check if spy operation requested
	jcs	<_spyend
	move		    #>'S',a
	cmp	x0,a
	jne	<_spyend

        move                #>'P',x0    ; yes, send first a preamble
	putc
        move                #>0,x0      ; send a 0 meaning non-complex data
        putc
	move		    #>512,a1
        move                a1,x:<spyn  ; spyn=512
	move		    #>1,a1
        move                a1,x:<spym  ; spym=1
        bset    #spyflg,x:<flag         ; set the spy flag true
	jmp	<_spyend

; spy is active, send lower 16bits in a-reg to the host
_spyon  move                x:<spym,b   ; b=spym
        move                #>1,y1      ; y1=1
        sub     y1,b        #>1,y1      ; b=b-y1  y1=1
        move                b,x:<spym   ; spym=b
	jne	<_spyend
        move                y1,x:<spym  ; spym=y1

        ; a-reg has 16bit word to tx via SCI
        move                a,y0        ; LSB first,  y0=a
	rep	#8
        lsr     a                       ; logical shift right, a1 only..
        move    a1,x0                   ; x0=a1
        putc                            ; x0 is tx via SCI

        move                y0,a        ; then HSB,  a=y0
        rep     #16                     ;
        lsr     a                       ;
        move    a1,x0                   ; x0=a1
        putc                            ; x0 is tx via SCI

        move                x:<spyn,a   ; check if all samples allready given
	move		    #>1,x0
        sub     x0,a                    ; a=spyn-1
        move                a,x:<spyn   ; spyn=spyn-1  ie decrement spyn
	jne	<_spyend
        bclr    #spyflg,x:<flag         ; set spyflag false again

_spyend rts
; end of spy routines
; -------------------------------------------------------------------------

        org     x:$2000      ; buffer in x-memory for input samples
buffer	dsm	buflen*4

        org     y:$2000      ; buffer in y-memory for output samples
        dsm     buflen*4

        org     x:user_data+6
flag	dc	0
spyn	ds	1
spym    ds      1

	end
; end of DSP asm program
